#pragma once

#include "util/output.hpp"
#include "util/string.hpp"
#include "util/workerpool.hpp"

class BaseNgramer {
   public:
   using SequenceId = uint32_t;
   virtual void query(const SequenceId id, const BorrowedString& document, QueryOut& out) = 0;
   void add(const SequenceId id, const BorrowedString& ngram, const uint32_t patternId=0);
   void remove(const SequenceId id, const BorrowedString& ngram);
   virtual void finalizeLoading() {}
   uint32_t patternIdCounter=0;
};


class STBaseNgramer {
   public:
   using SequenceId = uint32_t;

   void query(const SequenceId, const BorrowedString& document, QueryOut& out) { query(document, out); }
   void add(const SequenceId, const BorrowedString& ngram) { add(ngram); }
   void remove(const SequenceId, const BorrowedString& ngram) { remove(ngram); }

   virtual void query(const BorrowedString& document, QueryOut& out) = 0;
   virtual void add(const BorrowedString& ngram) = 0;
   virtual void remove(const BorrowedString& ngram) = 0;
   virtual void finalizeLoading() {}
};

class MTBaseNgramer : public BaseNgramer{
public:
   size_t getThreadId() { return workerPool::getWorkerThreadId(); }
   void accountAdds(size_t adds);
   virtual void initThreadState(size_t numThreads) = 0;
   virtual void checkAndMaybeDoGrow() {};
};
