#include "singlethreaded/awesomengramer.hpp"
#include "singlethreaded/hashngramer.hpp"
#include "singlethreaded/hashtreengramer.hpp"
#include "singlethreaded/hashvecngramer.hpp"
#include "singlethreaded/janngramer.hpp"
#include "singlethreaded/ngramer.hpp"
#include "singlethreaded/nhashtreengramer.hpp"
#include "singlethreaded/vechashvecngramer.hpp"
#include "util/output.hpp"
#include "util/shared.hpp"
#include "util/string.hpp"
#include <cstdint>
#include <gtest/gtest.h>

template <typename NgramProcessor> void testNgramProcessor()
{
   std::vector<char> buffer0;
   QueryOut out0(buffer0);
   std::vector<char> buffer1;
   QueryOut out1(buffer1);
   std::vector<char> buffer2;
   QueryOut out2(buffer2);
   std::vector<char> buffer3;
   QueryOut out3(buffer3);
   std::vector<char> buffer4;
   QueryOut out4(buffer4);


   NgramProcessor ngramer;
   ngramer.add(strToBorrowed("director"));
   ngramer.query(strToBorrowed("director"), out0);
   ASSERT_EQ(out0.toString(), "director\n");
   ngramer.add(strToBorrowed("conference"));
   ngramer.add(strToBorrowed("health"));
   ngramer.add(strToBorrowed("health director"));
   ngramer.add(strToBorrowed("one of the"));
   ngramer.query(strToBorrowed("for the eighth year the princeton review has named nkua "
                               "university one of the best colleges in the midwest"),
                 out1);
   ASSERT_EQ(out1.toString(), "one of the\n");
   ngramer.add(strToBorrowed("public health"));
   ngramer.query(strToBorrowed("the 2013 new york state health director conference "
                               "as always it is an excellent opportunity to meet "
                               "and mingle with more than 350 of the states top "
                               "public health leaders"),
                 out2);
   ASSERT_EQ(out2.toString(), "health|health director|director|conference|public health\n");
   ngramer.add(strToBorrowed("directory"));
   ngramer.remove(strToBorrowed("health"));
   ngramer.remove(strToBorrowed("does_not_exist"));
   ngramer.query(strToBorrowed("the public health director is a job that allows you "
                               "to enjoy all the benefits that the health field has "
                               "to offer"),
                 out3);
   ASSERT_EQ(out3.toString(), "public health|health director|director\n");

   ngramer.add(strToBorrowed("health director benefit"));
   ngramer.query(strToBorrowed("health director benefit"), out4);
   ASSERT_EQ(out4.toString(), "health director|health director benefit|director\n");
}

TEST(STNgramer, TreeNgramer) { testNgramProcessor<STNgramer>(); }

TEST(STNgramer, HashNgramer) { testNgramProcessor<STHashNgramer>(); }

TEST(STNgramer, HashVecNgramer) { testNgramProcessor<STHashVecNgramer>(); }

TEST(STNgramer, VecHashVecNgramer) { testNgramProcessor<STVecHashVecNgramer>(); }

TEST(STNgramer, HashTreeNgramer) { testNgramProcessor<STHashTreeNgramer>(); }

TEST(STNgramer, NHashTreeNgramer) { testNgramProcessor<STNHashTreeNgramer>(); }

TEST(STNgramer, JanNGramer) { testNgramProcessor<STJanNgramer>(); }

TEST(STNgramer, AwesomeNGramer) { testNgramProcessor<STAwesomeNgramer>(); }