#include "singlethreaded/nhashtreengramer.hpp"
#include "util/shared.hpp"
#include <algorithm>
#include <iostream>
#include <iterator>
#include <sstream>
#include <unordered_set>

void STNHashTreeNgramer::query(const BorrowedString& document, QueryOut& out)
{
   words.reserve(document.size());
   wordHashes.reserve(words.size());

   tokenize::wordSplits(document, ' ', [this](const BorrowedString& prefix) {
      words.emplace_back(prefix);
      wordHashes.emplace_back(std::hash<BorrowedString>()(prefix));
   });

   for (size_t i = 0; i < words.size(); i++) {
      auto match = hashtree.fastQuery(words[i], wordHashes[i]);
      for (size_t j = i + 1; match != hashtree.end(); j++) {
         if (match.second) {
            auto key = hashtree.getKey(match.first);
            if (found.find(key) == found.end()) {
               found[key] = 0;
               out.addNgram(key);
            }
         }

         if (j == words.size()) {
            break;
         }
         else {
            match = hashtree.fastQuery(words[j], wordHashes[j], match.first);
         }
      }
   }

   words.clear();
   wordHashes.clear();
   found.clear();
   out.finishResult();
}

void STNHashTreeNgramer::add(const BorrowedString& ngram)
{
   auto storedNgram = ngram.toOwned();
   auto borrowedStoredNgram = BorrowedString::fromOwned(storedNgram);

   hashtree.add(borrowedStoredNgram);
   ngrams.emplace_back(std::move(storedNgram));
}

void STNHashTreeNgramer::remove(const BorrowedString& ngram) { hashtree.remove(ngram); }

void STNHashTreeNgramer::finalizeLoading() { hashtree.optimizeGrowth(); }
