#pragma once

#include "campers/megahashtable.hpp"
#include "util/basengramer.hpp"
#include "util/hashtree.hpp"
#include "util/output.hpp"
#include "util/smallstring.hpp"
#include "util/string.hpp"
#include "util/stringarena.hpp"
#include <string>
#include <unordered_set>
#include <vector>

struct AwesomePatternInfo {
   uint32_t version;
   uint16_t shortestSuffix;
   uint16_t longestSuffix;

   AwesomePatternInfo()
      : version(std::numeric_limits<uint16_t>::max()), shortestSuffix(std::numeric_limits<uint16_t>::max()), longestSuffix(0)
   {
   }

   void invalidate() { version = std::numeric_limits<uint16_t>::max(); }
};

class STAwesomeNgramer : public STBaseNgramer {
   StringArena arena;
   campers::MegaHashMap<SmallString<>, AwesomePatternInfo, campers::CampersHash64> patterns;
   uint16_t version;

   using HashType = decltype(patterns)::HashType;
   std::vector<const char*> words;
   std::vector<HashType> wordHashes;

   public:
   STAwesomeNgramer() : arena(2 << 17), patterns(2 << 17), version(0) {}

   void query(const BorrowedString& document, QueryOut& out) override;
   void add(const BorrowedString& ngram) override;
   void remove(const BorrowedString& ngram) override;
   void finalizeLoading() override;
};