#include "Pattern.hpp"
#include <string.h>

using namespace std; 

Pattern Pattern::build(const char* string,uint32_t length){ 
  Pattern pattern;
  memset(&pattern,0, sizeof(Pattern));
  if(length<=SHORT_STRING_LIMIT){
    memcpy(&pattern.inlinedString.data,string,length);
  } else {
    memcpy(&pattern.inlinedString.length+1,string,PREFIX_LENGTH);
    pattern.fullString.pointer=reinterpret_cast<uintptr_t>(string); 
  } 
  pattern.inlinedString.length=length;
  return pattern; 
}

Pattern::Pattern(const string_view& ngram) { 
  uint32_t length=ngram.size();
  auto string = ngram.data();
  memset(this,0, sizeof(Pattern));
  inlinedString.length=length;
  if(length<=SHORT_STRING_LIMIT){
    memcpy(&inlinedString.data,string,length);
  } else {
    //memcpy(inlinedString.data,string,PREFIX_LENGTH);
    fullString.pointer=reinterpret_cast<uintptr_t>(string); 
  } 
}





