#include "util/timer.hpp"
#include <atomic>
#include <chrono>
#include <iostream>

namespace {
std::chrono::high_resolution_clock::time_point startTime;
util::timer::Cycles startCycles;
uint64_t normCycles;

uint64_t startDeltaMs()
{
   auto current = std::chrono::high_resolution_clock::now();
   return std::chrono::duration_cast<std::chrono::milliseconds>(current - startTime).count();
}

uint64_t computeNormCycles(uint32_t durationMs)
{
   while (startDeltaMs() < durationMs) {
   }
   return (util::timer::cycles() - startCycles).value / (startDeltaMs() * 1000);
}
}


namespace util {
namespace timer {
void initStartTime()
{
   startTime = std::chrono::high_resolution_clock::now();
   startCycles = timer::cycles();
   normCycles = 0;
}

uint64_t cyclesToMicroseconds(const Cycles& cycles)
{
   if (normCycles == 0) {
      normCycles = computeNormCycles(50);
      std::cerr << normCycles << std::endl;
   }
   return cycles.value / normCycles;
}

uint64_t now() { return cyclesToMicroseconds(cycles() - startCycles); }
}
}