#pragma once

#include "util/string.hpp"
#include <cstdint>
#include <string>
#include <vector>
#include <atomic>
#include <iostream>

void writeNoFlush(const std::vector<char>& buffer);
void writeToStdout(const std::vector<char>& buffer);

struct OutputPattern {
   BorrowedString pattern;
   unsigned position;
   OutputPattern(unsigned position, BorrowedString pattern) : pattern(pattern), position(position) {}

   inline bool operator< (const OutputPattern& rhs)
   { 
      if (position == rhs.position) {
         return pattern.size() < rhs.pattern.size();
      }
      return position < rhs.position; 
   }
};
typedef std::vector<OutputPattern> OutputVector;


static const unsigned QUERY_PARTITIONS=8;


class QueryOut {
   std::vector<char> buffer;
   bool started;
   std::atomic<bool> done;
   std::atomic<uint32_t> partitionsDone{0};

   public:
   std::vector<OutputVector> outputVectors{QUERY_PARTITIONS};

   QueryOut(__attribute__((unused)) std::vector<char>& deactivatedBuffer) :  started(false), done{false} {}
   QueryOut() : started(false), done{false} { 
      buffer.reserve(1<<11);
   }


   void addNgram(const BorrowedString& ngram);
   void finishResult();
   void reset() {
      buffer.clear();
      done=false; started=false;
      partitionsDone=0;
      for(auto& v : outputVectors) {
         v.clear();
      }
   }
   void write() { writeNoFlush(buffer); }
   void write(std::vector<char>& target);
   bool isDone() { return done; }
   void mergePartitions();

   std::string toString() const;


};


