#pragma once

#include "campers/megahashtable.hpp"
#include "util/basengramer.hpp"
#include "util/output.hpp"
#include "util/string.hpp"
#include <map>
#include <string>
#include <vector>

class STHashVecNgramer : public STBaseNgramer {
   std::vector<OwnedString> ngramStore;
   campers::MegaHashMap<BorrowedString, std::vector<std::pair<BorrowedString, size_t>>> ngrams;
   std::vector<bool> found;
   std::vector<uint32_t> clear;

   public:
   STHashVecNgramer() : ngrams(2 << 16) {}

   void query(const BorrowedString& document, QueryOut& out) override;
   void add(const BorrowedString& ngram) override;
   void remove(const BorrowedString& ngram) override;
   void finalizeLoading() override;
};