#ifndef JAN_MATCHER_HPP
#define JAN_MATCHER_HPP

#include "Matcher.hpp"
#include <experimental/string_view>
#include <vector>
#include "Pattern.hpp"
#include "campers/hashtable.hpp"
#include "google/farmhash.hpp"
#include <stdint.h>
#include <stdint.h>
#include "Hash.hpp"


using namespace std;
using namespace campers;
using namespace std::experimental;

class JanMatcher : public Matcher {

  struct WordInfo {
    uint32_t version,longestSuffix;
    WordInfo() : version(UINT32_MAX), longestSuffix(0) {}
  };

  struct stringhash {
    public:
      std::size_t operator()(const string_view& s) const
      {
        return util::Hash(s.data(), s.size());
      }

      size_t operator()(const Pattern& p) const
      {
        return util::Hash(p.data(), p.size());
      }
      size_t operator()(const char* str, uint32_t len) const
      {
        //return crc32_hash_rowdy(str,len);
        return crc32_hash_rowdy_max16(str,len);
        //return util::Hash(str, len);
      }
  };
  stringhash hash;


  typedef HashMap<Pattern,WordInfo,stringhash> hashmap;
  typedef vector<hashmap> ngramStorage;


  const uint32_t INIT_CAPACITY=1ul<<16;
  const uint32_t INIT_SIZE_QUERY_VECTORS=1ul<<7;

  hashmap nGrams;

  unsigned cur_max_n=0;
  uint32_t version = 0;

  const uint32_t OUTBUF_SIZE=1<<15;


  unsigned stringBufSize;
  unsigned modBits;

  inline unsigned nextInRing(unsigned ringPos){return (ringPos+1)&modBits;}
  inline unsigned prevInRing(unsigned ringPos){return (ringPos-1)&modBits;}


  public:
  void resetStats() {nGrams.collisionCounter=0; nGrams.lookupCounter=0;}
  void printStats() {cerr << "collisions:"<< nGrams.collisionCounter << " lookups:" << nGrams.lookupCounter << endl;}
  void grow() { nGrams.grow(); }
    JanMatcher();
    void query(const std::experimental::string_view document) noexcept;
    void add(const string_view ngram) noexcept;
    void remove(const string_view ngram) noexcept;
    ~JanMatcher();
};
#endif
