#pragma once

#include <stdint.h>
#include "nmmintrin.h"


// Some primes between 2^63 and 2^64 for various uses.
// from city hash
static const uint64_t k0 = 0xc3a5c85c97cb3127ULL;
static const uint64_t k1 = 0xb492b66fbe98f273ULL;
static const uint64_t k2 = 0x9ae16a3b2f90404fULL;

// Magic numbers for 32-bit hashing.  Copied from Murmur3.
static const uint32_t c1 = 0xcc9e2d51;
static const uint32_t c2 = 0x1b873593;

static uint64_t crc32_hash_rowdy(const char* start, uint64_t len){
  uint64_t a=k0&0xFFFFFFFF;
  const uint64_t* bulk=reinterpret_cast<const uint64_t*>(start);
  for(auto end=bulk+(len/8);bulk<end;++bulk){
    a=_mm_crc32_u64(a,*bulk);
  }
  auto rest = len&7;
  if(rest){
    auto mask = (1ull<<(rest*8))-1;
    auto inp=*bulk&mask;
    a=_mm_crc32_u64(a,inp);
  }
  return a*k1;
}

static uint64_t crc32_hash_rowdy_max16(const char* start, uint64_t len){
  uint64_t a=k0&0xFFFFFFFF;
  const uint64_t* bulk=reinterpret_cast<const uint64_t*>(start);
  if(len>=8){
    a=_mm_crc32_u64(a,*bulk++); 
    if(len>=16){ 
      return _mm_crc32_u64(a,*bulk);
    }
  } 
  auto rest = len&7;
  if(rest){
    auto mask = (1ull<<(rest*8))-1;
    auto inp=*bulk&mask;
    a=_mm_crc32_u64(a,inp);
  }
  return a*k1;
}
