import com.sun.source.tree.Tree;

import java.util.*;

public class Telefonbuch {

    private static String getRandomString(String chars, int length) {
        StringBuilder salt = new StringBuilder();
        Random rnd = new Random();
        while (salt.length() < length) { // length of the random string.
            int index = (int) (rnd.nextFloat() * chars.length());
            salt.append(chars.charAt(index));
        }
        return salt.toString();
    }

    private static class Eintrag {
        Eintrag(String telefonNummer, String name) {
            this.telefonNummer = telefonNummer;
            this.name = name;
        }

        String telefonNummer;
        String name;

        @Override
        public String toString() {
            return "Eintrag{ " +
                    "number='" + telefonNummer + '\'' +
                    ", name='" + name + '\'' +
                    " }";
        }
    }

    private static Eintrag[] erstelleTelefonbuch(int anzEintraege) {
        Eintrag[] telefonbuch = new Eintrag[anzEintraege];
        Set<String> eindeutigeNummern = new HashSet<>();

        for (int i = 0; i < anzEintraege; i++) {
            String generierteNummer = getRandomString("0123456789", 8);
            while (eindeutigeNummern.contains(generierteNummer)) {
                generierteNummer = getRandomString("0123456789", 8);
            }
            eindeutigeNummern.add(generierteNummer);

            telefonbuch[i] = new Eintrag(generierteNummer, getRandomString("ABCDEFGHIJKLMNOPQRSTUVWabcdefghijklmnopqrstuvw", 12));
        }

        return telefonbuch;
    }

    public static void main(String[] args) {
        int anzEintraege = 10_000_000;
        Eintrag[] telefonbuch = erstelleTelefonbuch(anzEintraege);

        Random rnd = new Random();
        int index = anzEintraege / 2; // rnd.nextInt(anzEintraege - 1);
        String gesuchteNummer = telefonbuch[index].telefonNummer;

        long start = System.nanoTime();

        for (Eintrag e : telefonbuch) {
            if (e.telefonNummer.equals(gesuchteNummer)) {
                System.out.println("gesuchte Nummer gefunden");
                break;
            }
        }

        long end = System.nanoTime();
        System.out.println("milli-secs:" + (end - start) / 1_000_000);

        // hash map

        start = System.nanoTime();

        Map<String, String> map = new HashMap<>();
        for (Eintrag e : telefonbuch) {
            map.put(e.telefonNummer, e.name);
        }
        end = System.nanoTime();
        System.out.println("hashmap bauen milli-secs:" + (end - start) / 1_000_000);

        start = System.nanoTime();

        if (map.containsKey(gesuchteNummer)) {
            System.out.println("gesuchte Nummer gefunden");
        }
        end = System.nanoTime();
        System.out.println("hashmap lookup milli-secs:" + (end - start) / 1_000_000);

        // tree map

        start = System.nanoTime();

        map = new TreeMap<>();
        for (Eintrag e : telefonbuch) {
            map.put(e.telefonNummer, e.name);
        }
        end = System.nanoTime();
        System.out.println("treemap bauen milli-secs:" + (end - start) / 1_000_000);

        start = System.nanoTime();

        if (map.containsKey(gesuchteNummer)) {
            System.out.println("gesuchte Nummer gefunden");
        }
        end = System.nanoTime();
        System.out.println("treemap lookup milli-secs:" + (end - start) / 1_000_000);

    }
}
