import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

class MovieVoteSearch {
  PriorityQueue<Movie> queue;

  class MovieComparator implements Comparator<Movie> {
    @Override
    public int compare(Movie o1, Movie o2) {
      // 0 <=> o1.votes == o2.votes
      // - <=> o1.votes < o2.votes
      // + <=> o1.votes > o2.votes
      return o1.votes - o2.votes;
    }
  }

  // Konstruktor
  public MovieVoteSearch() {
    queue = new PriorityQueue<>(new MovieComparator());
    // queue = new PriorityQueue<>(Comparator.comparingInt(o -> o.votes));
  }

  public void insertMovieWithVotes(int votes, Movie movie) {
    queue.add(movie);
  }

  public Movie getMovieWithFewestVotes() {
    return queue.peek();
  }

  // Dieser Client verwendet Ihre Implementierung
  public static void main(String[] args) {
    MovieVoteSearch movieSearch = new MovieVoteSearch();

    // Filme einfuegen
    List<Movie> movies = Movie.readMoviesFromFile("movies.txt");
    for (Movie m : movies) {
      movieSearch.insertMovieWithVotes(m.votes, m);
    }

    // Punktzugriff
    Movie movie = movieSearch.getMovieWithFewestVotes();

    // Ausgabe
    System.out.println(movie);
  }
}