import java.util.*;

class MovieTitleSearch {
  HashMap<String, Movie> map;

  // Konstruktor
  public MovieTitleSearch() {
    map = new HashMap<>();
  }

  public void insertMovieForTitle(String title, Movie movie) {
    map.put(title, movie);
  }

  public Movie getMovieForTitle(String title) {
    return map.get(title);
  }

  // Dieser Client verwendet Ihre Implementierung
  public static void main(String[] args) {
    MovieTitleSearch movieSearch = new MovieTitleSearch();

    // Filme einfuegen
    List<Movie> movies = Movie.readMoviesFromFile("movies.txt");
    for (Movie m : movies) {
      movieSearch.insertMovieForTitle(m.title, m);
    }

    // Punktzugriff
    Movie movie = movieSearch.getMovieForTitle("Pulp Fiction");

    // Ausgabe
    System.out.println(movie);
  }
}