import java.util.*;

class MovieRankSearch {
  ArrayList<Movie> list;

  // Konstruktor
  public MovieRankSearch() {
    list = new ArrayList<>();
  }

  public void insertMovieWithRank(int rank, Movie movie) {
    while (list.size() <= rank) {
      list.add(null);
    }

    list.set(rank, movie);
  }

  public Movie getMovieForRank(int rank) {
    return list.get(rank);
  }

  // Dieser Client verwendet Ihre Implementierung
  public static void main(String[] args) {
    MovieRankSearch movieSearch = new MovieRankSearch();

    // Filme einfuegen
    List<Movie> movies = Movie.readMoviesFromFile("movies.txt");
    for (Movie m : movies) {
      movieSearch.insertMovieWithRank(m.rank, m);
    }

    // Punktzugriff
    Movie movie = movieSearch.getMovieForRank(42);

    // Ausgabe
    System.out.println(movie);
  }
}