import java.util.*;

class MovieRangeSearch {
  TreeMap<Integer, List<Movie>> tree;

  // Konstruktor
  public MovieRangeSearch() {
    tree = new TreeMap<>();
  }

  public void insertMovieForYear(int year, Movie movie) {
    if (!tree.containsKey(year)) {
      tree.put(year, new ArrayList<>());
    }

    tree.get(year).add(movie);
  }

  public Collection<Movie> getMoviesBetweenYears(int fromYear, int toYear) {
    List<Movie> result = new ArrayList<>();

    SortedMap<Integer, List<Movie>> map = tree.subMap(fromYear, toYear);

    for (List<Movie> list : map.values()) {
      result.addAll(list);
    }

    return result;
  }

  // Dieser Client verwendet Ihre Implementierung
  public static void main(String[] args) {
    MovieRangeSearch movieSearch = new MovieRangeSearch();

    // Filme einfuegen
    List<Movie> movies = Movie.readMoviesFromFile("movies.txt");
    for (Movie m : movies) {
      movieSearch.insertMovieForYear(m.year, m);
    }

    // Bereichszugriff
    Collection<Movie> list = movieSearch.getMoviesBetweenYears(1950, 1959);

    // Ausgabe
    System.out.println("Filme zwischen 1950 und 1959:");
    for (Movie m : list) {
      System.out.println(m);
    }
  }
}