#include "util/shared.hpp"
#include "util/log.hpp"

#include <iterator>
#include <sstream>

Operation toOperation(const char c)
{
   switch (c) {
      case 'Q':
         return Operation::Query;
      case 'A':
         return Operation::Addition;
      case 'D':
         return Operation::Removal;
      default:
         FATAL_ERROR("Unrecognized operation c");
   }
}

std::vector<std::string> orderResult(std::vector<std::pair<std::string, size_t>>&& ngrams)
{
   auto cmp = [](const std::pair<std::string, size_t>& a, const std::pair<std::string, size_t>& b) {
      return (a.second < b.second) || ((a.second == b.second) && a.first.size() < b.first.size());
   };
   std::sort(ngrams.begin(), ngrams.end(), cmp);

   std::vector<std::string> result;
   for (auto ngram : ngrams) {
      result.emplace_back(std::move(ngram.first));
   }
   return result;
}

std::string stringify(const std::vector<std::string>& strings)
{
   std::ostringstream buffer;
   bool first = true;
   if (strings.size() > 0) {
      for (auto& string : strings) {
         if (first) {
            first = false;
         }
         else {
            buffer << '|';
         }
         buffer << string;
      }
   }
   else {
      buffer << "-1";
   }

   return buffer.str();
}
