#include "util/output.hpp"
#include "util/log.hpp"
#include <cstdio>
#include <string>
#include <algorithm>
#include <iterator>
//#include <queue>
#include <boost/heap/priority_queue.hpp>
#include <iostream>

using namespace boost::heap;

static const char RECORD_DELIMITER = '|';
static const char QUERY_DELIMITER = '\n';

void QueryOut::addNgram(const BorrowedString& ngram)
{
   auto strLength = ngram.size();
   buffer.reserve(buffer.size() + strLength + 2);
   if (started) {
      buffer.emplace_back(RECORD_DELIMITER);
   } else {
      started = true;
   }
   buffer.insert(std::end(buffer), ngram.begin(), ngram.end());
}


void QueryOut::finishResult()
{
   if (!started) {
      buffer.emplace_back('-');
      buffer.emplace_back('1');
   }
   buffer.emplace_back(QUERY_DELIMITER);
   done=true;
}


std::string QueryOut::toString() const { return std::string(buffer.data(), buffer.size()); }

void QueryOut::write(std::vector<char>& target) {
   target.reserve(target.size()+buffer.size());
   target.insert(std::end(target), buffer.begin(), buffer.end());
}

void writeNoFlush(const std::vector<char>& buffer)
{
   assert(buffer.size()>0);
   auto result = fwrite(buffer.data(), 1, buffer.size(), stdout);
   if (result != buffer.size()) {
      FATAL_ERROR("Bad output buffer " << result << "::" << buffer.size());
   }
}
void writeToStdout(const std::vector<char>& buffer)
{
   writeNoFlush(buffer);
   fflush(stdout);
}

unsigned getPos(std::vector<OutputVector>& outputVectors, std::vector<unsigned>& positions, unsigned id) {
   return outputVectors[id][positions[id]].position; 
}

BorrowedString& fetchPattern(std::vector<OutputVector>& ouputVectors, std::vector<unsigned>& positions, unsigned id) {
   return ouputVectors[id][positions[id]++].pattern;
}

BorrowedString& getNextWord(std::vector<OutputVector>& outputVectors, std::vector<unsigned>& positions) {
   if(getPos(outputVectors, positions, 0) < getPos(outputVectors, positions, 1)){
      return fetchPattern(outputVectors, positions, 0);
   }
   return fetchPattern(outputVectors, positions, 1); 

}

struct PrioElem 
{
   unsigned vectorIndex;
   const OutputPattern* iter;

   PrioElem(unsigned vectorIndex, const OutputPattern* start):vectorIndex(vectorIndex),iter(start) {}

};

bool operator<(const PrioElem& lhs,const PrioElem& rhs)  
{ 
	if (lhs.iter->position == rhs.iter->position) {
		return lhs.iter->pattern.size() > rhs.iter->pattern.size();
	}
	return lhs.iter->position > rhs.iter->position; 
}


void QueryOut::mergePartitions()
{
   
	//wait until all partitions are done
	if(partitionsDone.fetch_add(1)!=(QUERY_PARTITIONS-1)) {
		return;
	}

	priority_queue<PrioElem> queue;
	queue.reserve(QUERY_PARTITIONS);
	for(int i=0; i<outputVectors.size();i++)
	{
		if (!outputVectors[i].empty())
		{
			queue.emplace(i,&outputVectors[i].front());
		}
	}

	while (!queue.empty())
	{
		auto xxx = queue.top();
		queue.pop();

		addNgram(xxx.iter->pattern); 

		// if more elements exist in the outputVector, add the next to the queue
		if (xxx.iter != &outputVectors[xxx.vectorIndex].back())
		{
			queue.emplace(xxx.vectorIndex, xxx.iter+1);
		}
	}


	finishResult();
}
