#include "singlethreaded/hashtreengramer.hpp"
#include "util/shared.hpp"
#include <algorithm>
#include <iostream>
#include <iterator>
#include <sstream>
#include <unordered_set>

void STHashTreeNgramer::query(const BorrowedString& document, QueryOut& out)
{
   auto matcher = hashtree.matcher();
   tokenize::wordSplits(document, ' ', [&out, &matcher, this](const BorrowedString& prefix) {
      matcher.match(prefix);

      matcher.handleMatches([&out, this](const BorrowedString& result) {
         if (found.find(result) == found.end()) {
            found[result] = 0;
            out.addNgram(result);
         }
      });
   });

   matcher.finish();
   matcher.handleMatches([&out, this](const BorrowedString& result) {
      if (found.find(result) == found.end()) {
         found[result] = 0;
         out.addNgram(result);
      }
   });

   found.clear();
   out.finishResult();
}

void STHashTreeNgramer::add(const BorrowedString& ngram)
{
   auto storedNgram = ngram.toOwned();
   auto borrowedStoredNgram = BorrowedString::fromOwned(storedNgram);

   hashtree.add(borrowedStoredNgram);
   ngrams.emplace_back(std::move(storedNgram));
}

void STHashTreeNgramer::remove(const BorrowedString& ngram) { hashtree.remove(ngram); }

void STHashTreeNgramer::finalizeLoading() { hashtree.optimizeGrowth(); }
