#include "singlethreaded/hashngramer.hpp"
#include "util/shared.hpp"
#include <algorithm>
#include <iostream>
#include <iterator>
#include <sstream>
#include <unordered_set>

void STHashNgramer::query(const BorrowedString& document, QueryOut& out)
{
   auto length = document.size();

   size_t current = 0;
   for (; current < length; current++) {
      if (document[current] != ' ') {
         break;
      }
   }
   size_t next = current;

   while (current < length) {
      for (size_t i = current + 1; i < length; i++) {
         if (document[i] == ' ') {
            next = i;
            break;
         }
      }

      if (next == current) {
         next = length;
      }

      auto prefix = document.substr(current, next - current);
      auto indexIt = ngrams.find(prefix.toOwnedRef());
      if (indexIt != ngrams.end()) {
         auto& index = indexIt->second;
         auto before = index.begin();
         for (auto i = before; i != index.end(); i++) {
            const auto& value = i->first;
            auto comp = document.compare(next, value.size(), value);
            if (comp < 0) {
               break;
            }
            if (comp == 0 && ((document.size() == (next + value.size())) || (document[next + value.size()] == ' '))) {
               auto result = document.substr(current, (next - current) + value.size());
               if (found.find(result) == found.end()) {
                  found.insert(result);
                  for (uint32_t j = 0; j < i->second; j++) {
                     out.addNgram(result);
                  }
               }
            }
         }
      }

      for (current = next + 1; current < length; current++) {
         if (document[current] != ' ') {
            break;
         }
      }
      next = current;
   }

   found.clear();
   out.finishResult();
}

void STHashNgramer::add(const BorrowedString& ngram)
{
   auto tokens = ngram.split(' ');

   auto match = ngrams.find(tokens.first.toOwnedRef());
   if (match == ngrams.end()) {
      ngrams[std::move(tokens.first.toOwned())][std::move(tokens.second.toOwned())] += 1;
   }
   else {
      match->second[std::move(tokens.second.toOwned())] += 1;
   }
}

void STHashNgramer::remove(const BorrowedString& ngram)
{
   auto tokens = ngram.split(' ');

   auto match = ngrams.find(tokens.first.toOwnedRef());
   if (match != ngrams.end()) {
      match->second.erase(tokens.second.toOwnedRef());
      if (match->second.empty()) {
         ngrams.erase(match);
      }
   }
}
