#pragma once

#include "btree_map.h"
#include "util/basengramer.hpp"
#include "util/output.hpp"
#include "util/string.hpp"
#include <map>
#include <string>
#include <vector>

class STNgramer : public STBaseNgramer {
   // std::vector<btree::btree_map<OwnedString, uint32_t>> ngrams;
   std::vector<std::map<OwnedString, uint32_t>> ngrams;

   public:
   STNgramer() : ngrams(256) {}

   void query(const BorrowedString& document, QueryOut& out) override;
   void add(const BorrowedString& ngram) override;
   void remove(const BorrowedString& ngram) override;
};