#include "baseline/ngramer.hpp"
#include "util/shared.hpp"
#include <algorithm>
#include <iterator>
#include <sstream>

std::vector<std::string> Ngramer::query(const std::string& document)
{
   std::vector<std::pair<std::string, size_t>> results;
   auto text = " " + document + " ";

   for (auto& ngram : ngrams) {
      auto needle = " " + ngram + " ";
      auto pos = text.find(needle);
      if (pos != std::string::npos) {
         results.push_back({ngram, pos});
      }
   }

   return orderResult(std::move(results));
}

void Ngramer::add(std::string&& ngram) { ngrams.emplace_back(ngram); }

void Ngramer::remove(const std::string& ngram)
{
   ngrams.erase(std::remove(ngrams.begin(), ngrams.end(), ngram), ngrams.end());
}
