#pragma once


/*
Code courtesy of Henrik Mühe
https://muehe.org/posts/profiling-only-parts-of-your-code-with-perf/
 */

#include <sstream>
#include <iostream>
#include <functional>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>

struct PerfCall
{

  /// pid of last started perf process
  pid_t pid;
  void startProfile(const std::string& name, std::string perfMode = "record"){
    std::string filename = name.find(".data") == std::string::npos ? (name + ".data") : name;

    // Launch profiler
    std::stringstream s;
    s << getpid();
    pid = fork();
    if (pid == 0) {
      auto fd=open("/dev/null",O_RDWR);
      dup2(fd,1);
      dup2(fd,2);
      exit(execl("/usr/bin/env","env", "perf",perfMode.data(),"-o",filename.c_str(),"-p",s.str().c_str(),nullptr));
    }
  }

  void endProfile(){
    // Kill profiler
    kill(pid,SIGINT);
    waitpid(pid,nullptr,0);
  }

  void profile(const std::string& name,std::function<void()> body) {
    startProfile(name);
    // Run body
    body();
    endProfile();
  }

  void profile(std::function<void()> body) {
    profile("perf.data",body);
  }
};
