import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;

public class Student {
  public int matrNr;
  public String name;
  public int semester;
  public Set<Vorlesung> vorlesungen;
  public Set<Pruefung> pruefungen;

  public Student(int matrNr, String name, int semester) {
    this.matrNr = matrNr;
    this.name = name;
    this.semester = semester;
    
    vorlesungen = new HashSet<Vorlesung>();
    pruefungen = new HashSet<Pruefung>();
  }
  
  public void belegeVorlesung(Vorlesung vorlesung) {
    if (!vorlesungen.contains(vorlesung)) {
      vorlesungen.add(vorlesung);
      vorlesung.erhoeheAnzahlHoerer();
    }
  }
  
  public void pruefen(Pruefung pruefung) {
    pruefungen.add(pruefung);
  }

  public float notenschnitt() {
    float durchschnittsNote = 0;
    for (Pruefung p : pruefungen) {
      durchschnittsNote += p.note/pruefungen.size();
    }
    return durchschnittsNote;
  }

  public short summeWochenstunden() {
    short summeSWS = 0;
    Iterator<Vorlesung> it = vorlesungen.iterator();
    while (it.hasNext()) {
      summeSWS += it.next().sws;
    }
    return summeSWS;
  }
}