#pragma once

#include "util/string.hpp"
#include <list>

class StringArena {
   struct ArenaChunk {
      char* start;
      char* current;
      const char* end;

      ArenaChunk(size_t capacity)
      {
         start = new char[capacity];
         current = start;
         end = start + capacity;
      }

      ~ArenaChunk() { delete[] start; }

      char* __attribute__((malloc)) allocate(size_t size)
      {
         if (current + size < end) {
            auto ptr = current;
            current += size;
            return ptr;
         }
         else {
            return nullptr;
         }
      }

      char* __attribute__((malloc)) allocateFit(size_t size)
      {
         // Try to avoid having a string split across two cache lines
         uintptr_t numericPtr = reinterpret_cast<uintptr_t>(current);
         if (((numericPtr + size) << 6) == ((numericPtr) << 6)) {
            return allocate(size);
         }
         else {
            current = reinterpret_cast<char*>(((((numericPtr) << 6)) + 1) >> 6);
            return allocate(size);
         }
      }
   };

   std::list<ArenaChunk> chunks;
   size_t lastChunkSize;

   void allocateChunk()
   {
      lastChunkSize = lastChunkSize << 1;
      chunks.emplace_front(lastChunkSize);
   }

   public:
   StringArena(size_t initialCapacity = 2 << 17) : lastChunkSize(initialCapacity)
   {
      chunks.emplace_front(initialCapacity);
   }

   char* __attribute__((malloc)) allocate(size_t size)
   {
      auto ptr = chunks.front().allocate(size);
      if (ptr != nullptr) {
         return ptr;
      }
      else {
         allocateChunk();
         return allocate(size);
      }
   }

   char* __attribute__((malloc)) allocateFit(size_t size)
   {
      auto ptr = chunks.front().allocateFit(size);
      if (ptr != nullptr) {
         return ptr;
      }
      else {
         allocateChunk();
         return allocateFit(size);
      }
   }

   template <typename StringType> BorrowedString intern(StringType& other)
   {
      const size_t length = other.size();
      const auto data = other.data();
      auto ptr = allocate(length); // TODO: Check again later if cacheline aligned storage might be worth it
      memcpy(ptr,data,length);
      return BorrowedString(ptr, length);
   }
};
