#include "multithreaded/interquery.hpp"
#include "util/output.hpp"
#include "util/shared.hpp"
#include "util/string.hpp"
#include <cstdint>
#include <gtest/gtest.h>

template <typename NgramProcessor> void testNgramProcessor()
{
   QueryOut out0;
   QueryOut out1;
   QueryOut out2;
   QueryOut out3;
   QueryOut out4;

   BaseNgramer::SequenceId id=0;

   NgramProcessor ngramer;
   auto& patternId=ngramer.patternIdCounter;
   patternId=0;
   ngramer.initThreadState(4);
   ngramer.add(id++,strToBorrowed("director"),patternId++);
   ngramer.query(id++,strToBorrowed("director"), out0);
   ASSERT_EQ(out0.toString(), "director\n");
   ngramer.add(id++,strToBorrowed("conference"),patternId++);
   ngramer.add(id++,strToBorrowed("health"),patternId++);
   ngramer.add(id++,strToBorrowed("health director"),patternId++);
   ngramer.add(id++,strToBorrowed("one of the"),patternId++);
   ngramer.query(id++,strToBorrowed("for the eighth year the princeton review has named nkua "
                               "university one of the best colleges in the midwest"),
                 out1);
   ASSERT_EQ(out1.toString(), "one of the\n");
   ngramer.add(id++,strToBorrowed("public health"),patternId++);
   ngramer.query(id++,strToBorrowed("the 2013 new york state health director conference "
                               "as always it is an excellent opportunity to meet "
                               "and mingle with more than 350 of the states top "
                               "public health leaders"),
                 out2);
   ASSERT_EQ(out2.toString(), "health|health director|director|conference|public health\n");
   ngramer.add(id++,strToBorrowed("directory"),patternId++);
   ngramer.remove(id++,strToBorrowed("health"));
   ngramer.remove(id++,strToBorrowed("does_not_exist"));
   ngramer.query(id++,strToBorrowed("the public health director is a job that allows you "
                               "to enjoy all the benefits that the health field has "
                               "to offer"),
                 out3);
   ASSERT_EQ(out3.toString(), "public health|health director|director\n");

   ngramer.add(id++,strToBorrowed("health director benefit"),patternId++);
   ngramer.query(id++,strToBorrowed("health director benefit"), out4);
   ASSERT_EQ(out4.toString(), "health director|health director benefit|director\n");
   out4.reset();
   
   ngramer.add(id++,strToBorrowed("health director benefit"),patternId++);
   ngramer.query(id++,strToBorrowed("health director benefit"), out4);
   ASSERT_EQ(out4.toString(), "health director|health director benefit|director\n");
}

template <typename NgramProcessor> void testRemoveAdd()
{

   {
      QueryOut out0;
      NgramProcessor ngramer;
      ngramer.initThreadState(4);
      ngramer.remove(0,strToBorrowed("director"));
      ngramer.add(1,strToBorrowed("director"),0);
      ngramer.query(2,strToBorrowed("director"), out0);
      ASSERT_EQ("director\n",out0.toString());
   }
   {
      QueryOut out0;
      NgramProcessor ngramer;
      ngramer.initThreadState(4);
      ngramer.add(1,strToBorrowed("director"),0);
      ngramer.remove(0,strToBorrowed("director"));
      ngramer.query(2,strToBorrowed("director"), out0);
      ASSERT_EQ("director\n",out0.toString());
   } 
}

template <typename NgramProcessor> void testAddRemove()
{
   {
      QueryOut out0; 
      NgramProcessor ngramer;
      ngramer.initThreadState(4);
      ngramer.add(0,strToBorrowed("director"),0);
      ngramer.remove(1,strToBorrowed("director"));
      ngramer.query(2,strToBorrowed("director"), out0);
      ASSERT_EQ("-1\n",out0.toString());
   }
#define INDEPENDENTADDREMOVE 1
#if INDEPENDENTADDREMOVE
   {
      QueryOut out0; 
      NgramProcessor ngramer;
      ngramer.initThreadState(4);
      ngramer.remove(1,strToBorrowed("director"));
      ngramer.add(0,strToBorrowed("director"),0);
      ngramer.query(2,strToBorrowed("director"), out0);
      ASSERT_EQ("-1\n",out0.toString());
   }
#endif
}

template <typename NgramProcessor> void testAddRemoveAdd()
{
   {
      QueryOut out0; 
      NgramProcessor ngramer;
      ngramer.initThreadState(4);
      ngramer.add(0,strToBorrowed("director"),0);
      ngramer.remove(1,strToBorrowed("director"));
      ngramer.add(2,strToBorrowed("director"),1);
      ngramer.query(3,strToBorrowed("director"), out0);
      ASSERT_EQ("director\n",out0.toString());
   }
   {
      QueryOut out0; 
      NgramProcessor ngramer;
      ngramer.initThreadState(4);
      ngramer.add(0,strToBorrowed("director"),0);
      ngramer.add(2,strToBorrowed("director"),1);
      ngramer.remove(1,strToBorrowed("director"));
      ngramer.query(3,strToBorrowed("director"), out0);
      ASSERT_EQ("director\n",out0.toString());
   }
}
template <typename NgramProcessor> void testMvccChain()
{
   {
      QueryOut out0; 
      NgramProcessor ngramer;
      ngramer.initThreadState(4);
      ngramer.add(0,strToBorrowed("director"),0);
      ngramer.remove(1,strToBorrowed("director"));
      ngramer.add(2,strToBorrowed("director"),1);
      ngramer.remove(4,strToBorrowed("director"));
      ngramer.query(5,strToBorrowed("director"), out0);
      ASSERT_EQ("-1\n",out0.toString());
   }

   {
      QueryOut out0; 
      NgramProcessor ngramer;
      ngramer.initThreadState(4);
      ngramer.add(0,strToBorrowed("director"),0);
      ngramer.add(2,strToBorrowed("director"),1);
      ngramer.remove(1,strToBorrowed("director"));
      ngramer.remove(4,strToBorrowed("director"));
      ngramer.query(5,strToBorrowed("director"), out0);
      ASSERT_EQ("-1\n",out0.toString());
   }
   {
      QueryOut out0; 
      NgramProcessor ngramer;
      ngramer.initThreadState(4);
      ngramer.add(0,strToBorrowed("director"),0);
      ngramer.add(2,strToBorrowed("director"),1);
      ngramer.remove(1,strToBorrowed("director"));
      ngramer.remove(4,strToBorrowed("director"));
      ngramer.add(5,strToBorrowed("director"),1);
      ngramer.query(6,strToBorrowed("director"), out0);
      ASSERT_EQ("director\n",out0.toString());
   }
}


TEST(MTNgramer, InterQuery) { testNgramProcessor<InterQAwesomeNgramer>(); }
TEST(MTNgramer, InterQueryRemoveAdd) { testRemoveAdd<InterQAwesomeNgramer>(); }
TEST(MTNgramer, InterQueryAddRemove) { testAddRemove<InterQAwesomeNgramer>(); }
TEST(MTNgramer, InterQueryAddRemoveAdd) { testAddRemoveAdd<InterQAwesomeNgramer>(); }
TEST(MTNgramer, InterQueryMvccChain) { testMvccChain<InterQAwesomeNgramer>(); }

