#include <string>
#include <iostream>
#include <cstdio>
#include <vector>
#include "JanMatcher.hpp"
#include "NeumannMatcher.hpp"
#include "StringHelper.hpp"
#include <unistd.h>
#include <string.h>
#include "util/sectiontimer.hpp"
#include "PerfCall.hpp"


using namespace std;

static const uint64_t bufSize = 1ull << 31;
static const uint64_t readChunkSize = 1ull<<16;

int main(){
  std::ios_base::sync_with_stdio(false);

  util::timer::initStartTime();
  SectionTimer t;
#if MATCHER == 2
  NeumannMatcher m;
#else
  JanMatcher m;
#endif
  char* const inBuffer = new char[bufSize];

  auto start = inBuffer;
  auto end = inBuffer;
  auto dataEnd = inBuffer;

  for(int64_t in = read(STDIN_FILENO, inBuffer, readChunkSize);
      in > 0;
      in = read(STDIN_FILENO, dataEnd, readChunkSize)){
    dataEnd+=in;

    while(end < dataEnd){
      end = firstNewline(start, dataEnd);
      if(end == dataEnd){
        break;
      }
      *end=' ';
      ++end;
      auto chars = end - start;
      std::experimental::string_view pattern(start, chars);
      if(pattern == "S "){
        goto done;
      }
      m.add(pattern);
      start = end;
    }
  }
done:
  // move rest to begin of buffer
  int64_t in = dataEnd-end;
  m.grow();
  m.grow();
  m.grow();
  m.grow();
  memmove(inBuffer,end, in);

  PerfCall perf;
  if(getenv("PERF")) perf.startProfile("workload");

  cout << "R" << endl;
  t.reset();
  m.resetStats();

  // while input available
nextBatch:
  start = inBuffer;
  end = inBuffer;
  dataEnd = inBuffer;
  bool readLast = false;
  if(in == 0){
    in = read(STDIN_FILENO, start, readChunkSize);
  }
  // consume entire batch
  util::timer::TimeCorrector<3> corrector;
  for(;in > 0;
      in = read(STDIN_FILENO, dataEnd, readChunkSize)){
    dataEnd+=in;

    while(end < dataEnd){
      //find next newline
      end = firstNewline(start, dataEnd);
      if(end == dataEnd){
        break;
      }
      t.traceParse();

digest:
      *end  = ' ';
      ++end;
      auto chars = end - start;
      char op = *start;
      std::experimental::string_view payload(start+2, chars-2);
      switch(op){
        case 'Q':
          {
            m.query(payload);
            t.traceQuery();
          }
          break;
        case 'A':
          {
            m.add(payload);
            t.traceAddition();
          }
          break;
        case 'D':
          {
            m.remove(payload);
            t.traceRemove();
          }
          break;
        case 'F':
          corrector.correct();
          fflush(stdout);
          in = dataEnd-end;
          memmove(inBuffer,end, in);
          t.traceWrite();
          goto nextBatch;
          break;
        default:
          cerr << endl << op << "Not supported" << endl;
          throw "Bullshit!";
      }
      start = end;
    }
  }
  //in case last line was not ended by newline, digest last line if it is a query
  if(!readLast && *start == 'Q'){
    readLast = true;
    goto digest;
  }
  if(getenv("PERF")) perf.endProfile();
  t.print();
  m.printStats();
}
