#ifndef STRING_HELPER_HPP
#define STRING_HELPER_HPP
#include "nmmintrin.h"
#include "immintrin.h"
#include <stdint.h>

//sse2 implementation
const char nls[16] = {'\n','\n','\n','\n','\n','\n','\n','\n','\n','\n','\n','\n','\n','\n','\n','\n'};
const __m128i newlines = _mm_loadu_si128((const __m128i*)nls);

inline char* firstNewline(char*__restrict__ start, char*__restrict__ end){
    for(;start < end; start += 16){
        auto chars = _mm_loadu_si128((const __m128i*)start);
        uint32_t hit = _mm_cmpistri(chars,newlines, _SIDD_CMP_EQUAL_EACH|_SIDD_UBYTE_OPS|_SIDD_LEAST_SIGNIFICANT);
        if(hit < 16){
            return std::min(start + hit, end);
        }
    }
    return end;
}


const char was[16] = {' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '};
const __m128i whitespaces = _mm_loadu_si128((const __m128i*)was);

inline const char* firstWhitespace(const char* __restrict__ start,const char* __restrict__ end){
    for(;start < end; start += 16){
        auto chars = _mm_loadu_si128((const __m128i*)start);
        uint32_t hit = _mm_cmpistri(chars,whitespaces, _SIDD_CMP_EQUAL_EACH|_SIDD_UBYTE_OPS|_SIDD_LEAST_SIGNIFICANT);
        if(hit < 16){
          return std::min(start + hit, end);
        }
    }
    return end;
}


inline const char* posOfFirstWhitespace(const char* __restrict__ start){
    while(true){
        auto chars = _mm_loadu_si128((const __m128i*)start);
        uint32_t hit = _mm_cmpistri(chars,whitespaces, _SIDD_CMP_EQUAL_EACH|_SIDD_UBYTE_OPS|_SIDD_LEAST_SIGNIFICANT);
        start += hit;
        if(hit < 16){
            return start;
        }
    }
}

inline bool compareSSE(const char* a, const char* b, uint32_t length) {
  auto end = a+length;
  for(;a<end;a+=16,b+=16,length-=16){
    auto aReg = _mm_loadu_si128((const __m128i*)a);
    auto bReg = _mm_loadu_si128((const __m128i*)b);
    if(_mm_cmpestrc(aReg,length,bReg,length,_SIDD_UBYTE_OPS|_SIDD_CMP_EQUAL_EACH|_SIDD_NEGATIVE_POLARITY))
      return false;
  }
  return true;
}

#endif
