public class Punkt
{
    double x;
    double y;
    double z;

    public Punkt(double x, double y, double z)
    {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void skalieren(double faktor)
    {
        x *= faktor;
        y *= faktor;
        z *= faktor;
    }

    public void verschieben(double deltaX, double deltaY, double deltaZ)
    {
        x += deltaX;
        y += deltaY;
        z += deltaZ;
    }

    public void rotieren(double alpha, double n1, double n2, double n3)
    {
        x = x * (n1 * n1 * (1 - Math.cos(alpha)) + Math.cos(alpha))
                + y * (n1 * n2 * (1 - Math.cos(alpha)) - n3 * Math.sin(alpha))
                + z * (n1 * n3 * (1 - Math.cos(alpha)) + n2 * Math.sin(alpha));
        y = x * (n2 * n1 * (1 - Math.cos(alpha)) + n3 * Math.sin(alpha))
                + y * (n2 * n2 * (1 - Math.cos(alpha)) + Math.cos(alpha))
                + z * (n2 * n3 * (1 - Math.cos(alpha)) - n1 * Math.sin(alpha));
        z = x * (n3 * n1 * (1 - Math.cos(alpha)) - n2 * Math.sin(alpha))
                + y * (n3 * n2 * (1 - Math.cos(alpha)) + n1 * Math.sin(alpha))
                + z * (n3 * n3 * (1 - Math.cos(alpha)) + Math.cos(alpha));
    }

    public String toString()
    {
        return "(" + x + "," + y + "," + z + ")";
    }

    public String serializeToObj()
    {
        return "v " + x + " " + y + " " + z + "\n";
    }
}
