import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class Polyeder
{
    static int test = 42;

    Flaeche[] huelle;

    public Polyeder(Flaeche[] huelle)
    {
        this.huelle = huelle;
    }

    public static Polyeder deserializeFromObj(String fileName)
            throws FileNotFoundException
    {
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        List<Punkt> punkte = new ArrayList<>();
        List<Flaeche> flaechen = new ArrayList<>();

        // obj dateien definieren erst alle punkte (vertices), und dann die flaechen (faces)
        reader.lines().forEach(l -> {
                    if (l.startsWith("v")) {
                        String[] koordinaten = l.split(" ");
                        punkte.add(new Punkt(Double.parseDouble(koordinaten[1]), Double.parseDouble(koordinaten[2]), Double.parseDouble(koordinaten[3])));
                    }
                    else if (l.startsWith("f")) {
                        String[] begrenzungsPunkte = l.replace("f ", "").split(" ");
                        Kante[] kanten = new Kante[begrenzungsPunkte.length];
                        for (int i = 0; i < begrenzungsPunkte.length; i++) {
                            int punkt1 = Integer.parseInt(begrenzungsPunkte[i]) - 1;
                            int punkt2 = Integer.parseInt(begrenzungsPunkte[(i + 1) % (begrenzungsPunkte.length)]) - 1;
                            kanten[i] = new Kante(punkte.get(punkt1), punkte.get(punkt2));
                        }
                        flaechen.add(new Flaeche(kanten));
                    }
                }
        );
        Flaeche[] huelle = new Flaeche[flaechen.size()];
        for (int i = 0; i < flaechen.size(); i++) {
            huelle[i] = flaechen.get(i);
        }
        return new Polyeder(huelle);
    }

    public Set<Punkt> findePunkte()
    {
        HashSet<Punkt> ergebnis = new HashSet<Punkt>();
        for (Flaeche flaeche : huelle) {
            ergebnis.addAll(flaeche.findePunkte());
        }
        return ergebnis;
    }

    public void skalieren(double faktor)
    {
        Set<Punkt> punkte = findePunkte();
        for (Punkt punkt : punkte) {
            punkt.skalieren(faktor);
        }
    }

    public void verschieben(double deltaX, double deltaY, double deltaZ)
    {
        Set<Punkt> punkte = findePunkte();
        for (Punkt punkt : punkte) {
            punkt.verschieben(deltaX, deltaY, deltaZ);
        }
    }

    public void rotieren(double alpha, double n1, double n2, double n3)
    {
        Set<Punkt> punkte = findePunkte();
        for (Punkt punkt : punkte) {
            punkt.rotieren(alpha, n1, n2, n3);
        }
    }

    public String toString()
    {
        StringBuilder ergebnis = new StringBuilder();
        for (int i = 0; i < huelle.length; i++) {
            ergebnis.append("Flaeche ").append(i).append(":\n").append(huelle[i]).append("\n");
        }
        return ergebnis.toString();
    }

    public void serializeToObj(String fileName)
            throws IOException
    {
        List<Punkt> punkte = new ArrayList<Punkt>(findePunkte());
        StringBuilder serializedPolyeder = new StringBuilder();

        for (Punkt punkt : punkte) {
            serializedPolyeder.append(punkt.serializeToObj());
        }

        for (Flaeche flaeche : this.huelle) {
            serializedPolyeder.append(flaeche.serializeToObj(punkte));
        }

        BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
        writer.write(serializedPolyeder.toString());
        writer.close();
    }
}
