import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Flaeche
{
    Kante[] begrenzung;

    public Flaeche(Kante[] begrenzung)
    {
        this.begrenzung = begrenzung;
    }

    public Set<Punkt> findePunkte()
    {
        HashSet<Punkt> ergebnis = new HashSet<Punkt>();
        for (Kante kante : begrenzung) {
            ergebnis.addAll(kante.findePunkte());
        }
        return ergebnis;
    }

    public String toString()
    {
        StringBuilder ergebnis = new StringBuilder();
        for (int i = 0; i < begrenzung.length; i++) {
            ergebnis.append("Kante ").append(i).append(": ").append(begrenzung[i]);
        }
        return ergebnis.toString();
    }

    // dies ist notwendig, um die richtige reihenfolge der punkte herauszufinden, bevor sie in die obj datei gespeichert werden können
    private List<Punkt> findeReihenfolge()
    {
        ArrayList<Punkt> ergebnis = new ArrayList<>();

        Set<Kante> uebrigeKanten = new HashSet<>();
        Collections.addAll(uebrigeKanten, this.begrenzung);
        uebrigeKanten.remove(this.begrenzung[0]);
        ergebnis.add(this.begrenzung[0].start);
        ergebnis.add(this.begrenzung[0].ende);
        Punkt letzterPunkt = this.begrenzung[0].ende;

        while (!uebrigeKanten.isEmpty()) {
            for (Kante k : uebrigeKanten) {
                if (k.start == letzterPunkt || k.ende == letzterPunkt) {
                    if (k.start == letzterPunkt) {
                        letzterPunkt = k.ende;
                    }
                    else {
                        letzterPunkt = k.start;
                    }
                    ergebnis.add(letzterPunkt);
                    uebrigeKanten.remove(k);
                    break;
                }
            }
        }
        ergebnis.remove(letzterPunkt);
        return ergebnis;
    }

    public String serializeToObj(List<Punkt> punkte)
    {
        StringBuilder sb = new StringBuilder("f ");
        List<Punkt> geordnetePunkte = findeReihenfolge();
        for (Punkt p : geordnetePunkte) {
            sb.append(punkte.indexOf(p) + 1).append(" ");
        }
        sb.append("\n");
        return sb.toString();
    }
}
