import java.io.IOException;

public class CLI
{
    public static void main(String[] args)
            throws IOException
    {
        // Lade Polyeder aus .obj Datei
        // Polyeder polyeder = Polyeder.deserializeFromObj("tetraeder.obj");

        // Punkte erzeugen
        Punkt a = new Punkt(1, 1, -1);
        Punkt c = new Punkt(-1, -1, -1);
        Punkt f = new Punkt(-1, 1, 1);
        Punkt h = new Punkt(1, -1, 1);

        // Kanten erzeugen
        Kante kante1 = new Kante(a, c);
        Kante kante2 = new Kante(a, f);
        Kante kante3 = new Kante(a, h);
        Kante kante4 = new Kante(c, f);
        Kante kante5 = new Kante(c, h);
        Kante kante6 = new Kante(f, h);

        // Flaechen erzeugen
        Kante[] begrenzung1 = {kante1, kante2, kante4};
        Flaeche flaeche1 = new Flaeche(begrenzung1);
        Kante[] begrenzung2 = {kante1, kante3, kante5};
        Flaeche flaeche2 = new Flaeche(begrenzung2);
        Kante[] begrenzung3 = {kante2, kante3, kante6};
        Flaeche flaeche3 = new Flaeche(begrenzung3);
        Kante[] begrenzung4 = {kante4, kante5, kante6};
        Flaeche flaeche4 = new Flaeche(begrenzung4);

        // Polyeder erzeugen
        Flaeche[] huelle = {flaeche1, flaeche2, flaeche3, flaeche4};
        Polyeder tetraeder = new Polyeder(huelle);
        System.out.println("=== Der Tetraeder ===\n");
        System.out.println(tetraeder);

        tetraeder.serializeToObj("tetraeder.obj");

        // Polyeder skalieren
        tetraeder.skalieren(2);
        System.out.println("--- Skalieren ---\n");
        System.out.println(tetraeder);
        tetraeder.serializeToObj("tetraeder_skaliert.obj");

        // Polyeder verschieben
        tetraeder.verschieben(1, 1, 1);
        System.out.println("--- Verschieben ---\n");
        System.out.println(tetraeder);
        tetraeder.serializeToObj("tetraeder_verschoben.obj");

        // Polyeder rotieren
        tetraeder.rotieren(Math.PI, 0, 0, 1);
        System.out.println("--- Rotieren ---\n");
        System.out.println(tetraeder);
        tetraeder.serializeToObj("tetraeder_rotiert.obj");
    }
}
