#include "util/sectiontimer.hpp"
#include <iostream>

namespace {
void updateCounter(util::timer::Cycles& counter, util::timer::Cycles& lastTime)
{
   auto newTime = util::timer::cycles();
   counter += (newTime - lastTime);
   lastTime = newTime;
}

void printIfNonZero(const util::timer::Cycles& counter, const std::string& name)
{
   auto duration = util::timer::cyclesToMicroseconds(counter);
   if (duration > 0) {
      std::cerr << name << duration << std::endl;
   }
}
}

void SectionTimer::traceParse() { updateCounter(parseTime, lastTime); }

void SectionTimer::traceQuery() { updateCounter(queryTime, lastTime); }

void SectionTimer::traceAddition() { updateCounter(additionTime, lastTime); }

void SectionTimer::traceRemove() { updateCounter(removeTime, lastTime); }

void SectionTimer::traceWrite() { updateCounter(writeTime, lastTime); }

void SectionTimer::print() const
{
   printIfNonZero(parseTime, "Parse:\t");
   printIfNonZero(queryTime, "Query:\t");
   printIfNonZero(additionTime, "Add:\t");
   printIfNonZero(removeTime, "Remove:\t");
   printIfNonZero(writeTime, "Write:\t");
}

void SectionTimer::reset()
{
   parseTime = {0};
   queryTime = {0};
   additionTime = {0};
   removeTime = {0};
   writeTime = {0};
   lastTime = util::timer::cycles();
}
