#pragma once

#include "unordered_map"
#include "unordered_set"

class WorkloadStats {
   uint64_t countDocs;
   uint64_t wordInDocs;
   uint64_t matchesDocs;
   uint64_t countAddLoad;
   uint64_t countAdd;
   uint64_t countRemove;
   uint64_t countFlush;
   std::unordered_set<std::string> searchNgrams;
   std::unordered_map<std::string, uint32_t> docWords;
   bool finishedLoading;


   public:
   WorkloadStats()
      : countDocs(0), wordInDocs(0), matchesDocs(0), countAddLoad(0), countAdd(0), countRemove(0), countFlush(0),
        searchNgrams(), docWords(), finishedLoading(false){};

   void analyzeQuery(const std::string& document, const std::string& output);

   void analyzeAddition(const std::string& ngram);

   void analyzeRemove(const std::string& ngram);

   void analyzeFlush();

   void finishLoad();

   void print() const;
};