#ifndef PATTERN_HPP
#define PATTERN_HPP

#include <iostream>
#include <stdint.h>
#include <string.h>
#include <experimental/string_view>
#include "nmmintrin.h"
#include "StringHelper.hpp"

using namespace std;
using namespace std::experimental;

class Pattern {


  public:
  static const unsigned SHORT_STRING_LIMIT = 28;
  static const unsigned PREFIX_LENGTH = 20;
  static bool inline isSmall(string_view nGram){ return nGram.size()<=SHORT_STRING_LIMIT;}

  inline const char* longString() const { return reinterpret_cast<char*>(fullString.pointer); }
  inline const char* prefix() const { return inlinedString.data; } 
  inline const char* data() const{ return isInlined() ? prefix() : longString(); }

  inline uint32_t size() const{ return inlinedString.length; }
  inline bool isInlined() const{ return size() <= SHORT_STRING_LIMIT; }

  union{
    struct{uint32_t length; char data[SHORT_STRING_LIMIT];} inlinedString;
    struct{uint32_t length; char prefix[PREFIX_LENGTH]; uint64_t pointer;} fullString;
  };

    Pattern() {};
    Pattern(const string_view& ngram);

  public: 

    static Pattern build(const char* string, uint32_t length);

    inline void setLength(uint32_t len) {inlinedString.length =len;} 


    inline bool operator==(const Pattern& other) const { 
      if(!memcmp(this,&other,PREFIX_LENGTH+4)){
        if(isInlined()){
          return fullString.pointer == other.fullString.pointer;
        } else {
          return compareSSE(longString(), other.longString(),size());
        }
      } 
      return false;
    }


   inline friend bool operator==(const Pattern& lhs, const std::experimental::string_view& rhs){
     auto size = lhs.size();
     if(size != rhs.size()){
       return false;
     }
     return compareSSE(lhs.data(),rhs.data(),size);
   }
};

#endif
