package db.university;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Professor {
    public static List<Professor> Parse(List<String> lines) {
        List<Professor> result = new ArrayList<>();
        for (String line : lines)
            result.add(new Professor(line));
        return result;
    }

    private Professor(String csv_row) {
        Pattern pattern = Pattern.compile("([0-9]*),(.*),(.*),([0-9]*)");
        Matcher matcher = pattern.matcher(csv_row);
        if (matcher.find()) {
            PersNr = Integer.parseInt(matcher.group(1));
            Name = matcher.group(2);
            Rang = matcher.group(3);
            Raum = Integer.parseInt(matcher.group(4));
        }
    }

    public int PersNr;
    public String Name;
    public String Rang;
    public int Raum;
}
