package db.university;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;

class CSVLoader {
    static List<String> Load(String filename) {
        List<String> lines = Collections.emptyList();
        try {
            lines = Files.readAllLines(Paths.get("university/" + filename), StandardCharsets.UTF_8);
        } catch (IOException ignored) {
        }
        return lines;
    }
}

// Hard-coded Java database for the well-known university schema
public class Database {

    public static Database LoadDatabase() {
        Database db = new Database();
        db.assistenten = Assistent.Parse(CSVLoader.Load("Assistenten.csv"));
        db.professoren = Professor.Parse(CSVLoader.Load("Professoren.csv"));
        db.studenten = Student.Parse(CSVLoader.Load("Studenten.csv"));
        db.vorlesungen = Vorlesung.Parse(CSVLoader.Load("Vorlesungen.csv"));
        db.hoeren = Hoeren.Parse(CSVLoader.Load("hoeren.csv"));
        db.pruefen = Pruefen.Parse(CSVLoader.Load("pruefen.csv"));
        db.voraussetzen = Voraussetzen.Parse(CSVLoader.Load("voraussetzen.csv"));
        return db;
    }

    public List<Professor> professoren;
    public List<Student> studenten;
    public List<Vorlesung> vorlesungen;
    public List<Assistent> assistenten;
    public List<Hoeren> hoeren;
    public List<Pruefen> pruefen;
    public List<Voraussetzen> voraussetzen;

}
