#include "util/workloadstats.hpp"
#include <cassert>
#include <iostream>
#include <sstream>

void WorkloadStats::analyzeQuery(const std::string& document, const std::string& output)
{
   assert(finishedLoading);
   countDocs++;
   std::stringstream docstream(document);
   for (std::string line; std::getline(docstream, line, ' ');) {
      docWords[line]++;
      wordInDocs++;
   }
   std::stringstream outstream(output);
   if (!output.empty()) {
      matchesDocs++;
      for (std::string line; std::getline(outstream, line, '|');) {
         matchesDocs++;
      }
   }
}

void WorkloadStats::analyzeAddition(const std::string& ngram)
{
   if (finishedLoading) {
      countAdd++;
   }
   else {
      countAddLoad++;
   }
   searchNgrams.insert(ngram);
}

void WorkloadStats::analyzeRemove(const std::string&)
{
   assert(finishedLoading);
   countRemove++;
}

void WorkloadStats::analyzeFlush()
{
   assert(finishedLoading);
   countFlush++;
}

void WorkloadStats::finishLoad()
{
   assert(!finishedLoading);
   finishedLoading = true;
}

void WorkloadStats::print() const
{
   std::cerr << "Initial:\t" << countAddLoad << std::endl;
   std::cerr << "NumQueries:\t" << countDocs << std::endl;
   std::cerr << "NumAdditions:\t" << countAdd << std::endl;
   std::cerr << "NumAdditionsLoad:\t" << countAddLoad << std::endl;
   std::cerr << "NumDeletes:\t" << countRemove << std::endl;
   std::cerr << "NumFlushes:\t" << countFlush << std::endl;
   auto perDoc = [&]() {
      if (countDocs == 0) {
         return (uint64_t)0;
      }
      else {
         return wordInDocs / countDocs;
      }
   }();
   std::cerr << "WordsPerDoc:\t" << perDoc << std::endl;
   auto prob = [&]() {
      if (wordInDocs == 0) {
         return 0.0;
      }
      else {
         return matchesDocs / (double)wordInDocs;
      }
   }();
   std::cerr << "MatchProbability:\t" << prob << std::endl;
}