#pragma once

#include <cstdint>
#include <cstdlib>
#include <string>

namespace util {
namespace timer {
struct Cycles {
   uint64_t value;
   inline Cycles& operator+=(const Cycles& a)
   {
      value += a.value;
      return *this;
   }
   inline friend Cycles operator+(const Cycles& a, const Cycles& b) { return Cycles{a.value + b.value}; }
   inline friend Cycles operator-(const Cycles& a, const Cycles& b) { return Cycles{a.value - b.value}; }
};

static inline Cycles cycles()
{
   uint32_t low, high;
   asm volatile("rdtsc" : "=a"(low), "=d"(high));
   return Cycles{(uint64_t)high << 32 | low};
}

void initStartTime();
uint64_t cyclesToMicroseconds(const Cycles& cycles);
uint64_t now();

template <uint32_t Factor> class TimeCorrector {
   Cycles lastCycles;
   Cycles runCycles;
   Cycles delayedCycles;
   bool disabled;

   public:
   TimeCorrector() : lastCycles(cycles()), runCycles(Cycles{0}), delayedCycles(Cycles{0})
   {
      //auto setting = getenv("NO_BRAKES");
      disabled = true;//(setting != nullptr);
   }

   void correct()
   {
      if (disabled) {
         return;
      }
      else {
         runCycles += cycles() - lastCycles;
         auto desiredDelay = Cycles{runCycles.value * (Factor - 1)} - delayedCycles;
         auto delayStart = cycles();
         while ((cycles() - delayStart).value < desiredDelay.value) {
         }
         delayedCycles += desiredDelay;
         lastCycles = cycles();
      }
   }
};
}
}
