#pragma once

#include "util/timer.hpp"
#include <iostream>

#ifdef DEBUG
#ifdef NDBGPRINT
#define LOG_PRINT(X)
#else
#define LOG_PRINT(X) std::cerr << timer::now() << " " << X << std::endl
#endif
#else
#define LOG_PRINT(X)
#endif

#define TIME_PRINT(X) std::cerr << "[" << util::timer::now() << "] TIMING: " << X << std::endl

#define FATAL_ERROR(X)                                                      \
   std::cerr << "[" << util::timer::now() << "] FATAL: " << X << std::endl; \
   exit(1)
