#include "singlethreaded/vechashvecngramer.hpp"
#include "util/shared.hpp"
#include <algorithm>
#include <iostream>
#include <iterator>
#include <sstream>
#include <unordered_set>

void STVecHashVecNgramer::query(const BorrowedString& document, QueryOut& out)
{
   processStringSplits(document, ' ', [&out, this](const BorrowedString& full, const BorrowedString& prefix,
                                                   const BorrowedString& remainder) {
      auto indexIt = ngrams[prefix[0]].find(prefix.toOwnedRef());
      if (indexIt != ngrams[prefix[0]].end()) {
         auto& index = indexIt->second;
         auto before = index.begin();
         for (auto i = before; i != index.end(); i++) {
            const auto& value = *i;
            if ((value.size() > remainder.size()) || (value != remainder.substr(0, value.size()).toOwnedRef())) {
               continue;
            }
            if (((value.size() == remainder.size()) || (remainder[value.size()] == ' '))) {
               auto result = full.substr(0, prefix.size() + value.size());
               if (found.find(result) == found.end()) {
                  found.insert(result);
                  out.addNgram(result);
               }
            }
         }
      }
   });

   found.clear();
   out.finishResult();
}

void STVecHashVecNgramer::add(const BorrowedString& ngram)
{
   auto tokens = ngram.split(' ');

   auto match = ngrams[ngram[0]].find(tokens.first.toOwnedRef());
   if (match == ngrams[ngram[0]].end()) {
      ngrams[ngram[0]][std::move(tokens.first.toOwned())].emplace_back(std::move(tokens.second.toOwned()));
   }
   else {
      match->second.emplace_back(std::move(tokens.second.toOwned()));
      std::sort(match->second.begin(), match->second.end());
   }
}

void STVecHashVecNgramer::remove(const BorrowedString& ngram)
{
   auto tokens = ngram.split(' ');

   auto match = ngrams[ngram[0]].find(tokens.first.toOwnedRef());
   if (match != ngrams[ngram[0]].end()) {
      match->second.erase(std::remove(match->second.begin(), match->second.end(), tokens.second.toOwnedRef()),
                          match->second.end());
      if (match->second.empty()) {
         ngrams[ngram[0]].erase(match);
      }
   }
}
