#pragma once

#include "util/basengramer.hpp"
#include "util/output.hpp"
#include "util/string.hpp"
#include <map>
#include <string>
#include <unordered_map>
#include <unordered_set>
#include <vector>

class STVecHashVecNgramer : public STBaseNgramer {
   std::vector<std::unordered_map<OwnedString, std::vector<OwnedString>>> ngrams;
   std::unordered_set<BorrowedString> found;

   public:
   STVecHashVecNgramer() : ngrams(256) {}

   void query(const BorrowedString& document, QueryOut& out) override;
   void add(const BorrowedString& ngram) override;
   void remove(const BorrowedString& ngram) override;
};