#pragma once

#include "campers/megahashtable.hpp"
#include "singlethreaded/hashtreengramer.hpp"
#include "util/basengramer.hpp"
#include "util/hashtree.hpp"
#include "util/output.hpp"
#include "util/string.hpp"
#include <string>
#include <unordered_set>
#include <vector>


class STNHashTreeNgramer : public STBaseNgramer {
   std::vector<BorrowedString> words;
   std::vector<uint32_t> wordHashes;

   std::vector<OwnedString> ngrams;
   HashTree<BorrowedString, decltype(SplitFn)> hashtree;
   campers::MegaHashMap<BorrowedString, char> found;

   public:
   STNHashTreeNgramer() : ngrams(), hashtree(SplitFn), found() { found.grow(1024); }

   void query(const BorrowedString& document, QueryOut& out) override;
   void add(const BorrowedString& ngram) override;
   void remove(const BorrowedString& ngram) override;
   void finalizeLoading() override;
};
