#include <iostream>
#include <fstream>
#include <unordered_map>
#include <vector>
#include <map>
#include <set>
#include <algorithm>
#include <chrono>
#include <cstring>

using namespace std;

static uint64_t MurmurHash64A ( const void * key, int len, uint64_t seed )
{
  const uint64_t m = 0xc6a4a7935bd1e995ull;
  const int r = 47;

  uint64_t h = seed ^ (len * m);

  const uint64_t * data = (const uint64_t *)key;
  const uint64_t * end = data + (len/8);

  while(data != end)
  {
    uint64_t k = *data++;

    k *= m;
    k ^= k >> r;
    k *= m;

    h ^= k;
    h *= m;
  }

  const unsigned char * data2 = (const unsigned char*)data;

  switch(len & 7)
  {
  case 7: h ^= uint64_t(data2[6]) << 48;
  case 6: h ^= uint64_t(data2[5]) << 40;
  case 5: h ^= uint64_t(data2[4]) << 32;
  case 4: h ^= uint64_t(data2[3]) << 24;
  case 3: h ^= uint64_t(data2[2]) << 16;
  case 2: h ^= uint64_t(data2[1]) << 8;
  case 1: h ^= uint64_t(data2[0]);
          h *= m;
  };

  h ^= h >> r;
  h *= m;
  h ^= h >> r;

  return h;
}

static uint64_t hashString(const char* str,unsigned len)
{
#if 1
   if (len<8) {
      uint64_t v=0;
      if (len>=4) { v=*reinterpret_cast<const uint32_t*>(str); str+=4; len-=4; }
      if (len>=2) { v=(v<<16)|(*reinterpret_cast<const uint16_t*>(str)); str+=2; len-=2; }
      if (len>=1) { v=(v<<8)|(*reinterpret_cast<const uint8_t*>(str)); }
      return v*11400714819323198485ull;
   } else {
      return (*reinterpret_cast<const uint64_t*>(str))*11400714819323198485ull;
   }
#elif 0
   constexpr uint64_t prime=0x100000001b3;
   uint64_t hash=0xcbf29ce484222325;
   if (len<8) {
      uint64_t v=0;
      if (len>=4) { v=*reinterpret_cast<const uint32_t*>(str); str+=4; len-=4; }
      if (len>=2) { v=(v<<16)|(*reinterpret_cast<const uint16_t*>(str)); str+=2; len-=2; }
      if (len>=1) { v=(v<<8)|(*reinterpret_cast<const uint8_t*>(str)); }
      hash^=v;
      return hash*prime;
   } else {
      while (len>=8) {
         hash^=*reinterpret_cast<const uint64_t*>(str);
         hash*=prime;
         str+=8; len-=8;
      }
      if (len) {
         unsigned ofs=8-len;
         hash^=(*reinterpret_cast<const uint64_t*>(str-ofs))>>ofs;
         hash*=prime;
      }
      return hash;
   }
#else
   return MurmurHash64A(str,len,0);
#endif
}

static inline uint64_t hashString(const string& s) { return hashString(s.data(),s.length()); }

/// A pattern
struct Pattern {
   /// The hash value
   uint64_t hash;
   /// The full string
   string pattern;
   /// The pattern length in words
   unsigned len;
   /// The last hit
   unsigned lastHit=0;
};

struct WordEntry {
   /// Additional patterns
   vector<Pattern> patterns;
   /// Last hit
   unsigned lastHit=0;
   /// Already a match?
   bool match=false;
};

static unordered_map<string,WordEntry> hashTable;

vector<string> split(const string& s)
{
   vector<string> result;
   string current;
   for (char c:s)
      if (c==' ') {
         result.push_back(move(current));
         current.clear();
      } else current+=c;
   result.push_back(move(current));
   return result;
}

static void addPattern(string& line)
{
   auto parts=split(line);
   if (parts.size()==1) {
      hashTable[parts[0]].match=true;
   } else {
      uint64_t rolling=0;
      for (unsigned index=0,limit=parts.size()-1;index!=limit;++index)
         rolling=(rolling>>8)|(hashString(parts[index])&(~((~0ull)>>8)));
      auto& e=hashTable[parts.back()];

      unsigned len=parts.size()-1;
      if (len>8) len=8;
      auto iter=lower_bound(e.patterns.begin(),e.patterns.end(),rolling,[len,&line](const Pattern& a,uint64_t b) { if (a.hash!=b) return a.hash<b; if (a.len!=len) return a.len<len; return a.pattern<line; });
      if (iter!=e.patterns.end()) {
         // Already known?
         if ((iter->hash==rolling)&&(iter->len==len)&&(iter->pattern==line))
            return;
      }
      e.patterns.insert(iter,Pattern{rolling,line,len});
   }
}

static void deletePattern(string& line)
{
   auto parts=split(line);
   if (parts.size()==1) {
      hashTable[parts[0]].match=false;
   } else {
      uint64_t rolling=0;
      for (unsigned index=0,limit=parts.size()-1;index!=limit;++index)
         rolling=(rolling>>8)|(hashString(parts[index])&(~((~0ull)>>8)));
      auto& e=hashTable[parts.back()];

      unsigned len=parts.size()-1;
      if (len>8) len=8;
      auto iter=lower_bound(e.patterns.begin(),e.patterns.end(),rolling,[len,&line](const Pattern& a,uint64_t b) { if (a.hash!=b) return a.hash<b; if (a.len!=len) return a.len<len; return a.pattern<line; });
      if (iter!=e.patterns.end()) {
         if ((iter->hash==rolling)&&(iter->len==len)&&(iter->pattern==line))
            e.patterns.erase(iter,iter+1);
      }
   }
}

static unsigned checks = 0, hitCount = 0;

static void checkMatch(vector<tuple<unsigned,unsigned,const string*>>& hits,Pattern& pattern,const char* begin,const char* limit,unsigned queryId)
   // Check if we have a match
{
   if (pattern.lastHit==queryId)
      return;

   checks++;
   unsigned patLen=pattern.pattern.length();
   if (patLen<=(limit-begin)) {
      if ((memcmp(limit-patLen,pattern.pattern.data(),patLen)==0)&&((patLen==(limit-begin))||((limit-patLen)[-1]==' '))) {
         hits.emplace_back(static_cast<unsigned>(limit-patLen-begin),patLen,&pattern.pattern);
         pattern.lastHit=queryId;
         hitCount++;
      }
   }
}

static inline uint64_t getFirst(uint64_t v,unsigned len) { return (len<8)?(v&(~((~0ull)>>(8*len)))):v; }

int main()
{
   ios_base::sync_with_stdio(false);

   // Initial processing
   string line;
   while (getline(cin,line)) {
      if (line=="S") break;
      addPattern(line);
   }
   cout << "R" << endl;
   auto start = chrono::steady_clock::now();

   // Process
   vector<tuple<unsigned,unsigned,const string*>> hits;
   string current;
   char c,c2;
   uint64_t rolling;
   unsigned queryId=0;
   unsigned words=0,candidates=0;
   while (cin.get(c)) {
      cin.get(c2); if (c2!=' ') { cerr << "malformed input" << endl; return 1; }
      getline(cin,line);
      switch (c) {
         case 'A': addPattern(line); break;
         case 'D': deletePattern(line); break;
         case 'Q': {
            hits.clear();
            current.clear();
            rolling=0; ++queryId;
            for (auto data=line.data(),iter=data,limit=iter+line.length();;++iter) {
               if ((iter==limit)||((*iter)==' ')) {
                  ++words;
                  auto iter2=hashTable.find(current);
                  if (iter2!=hashTable.end()) {
                     auto& e=*iter2;
                     ++candidates;
                     if (e.second.match&&(e.second.lastHit!=queryId)) {
                        hits.emplace_back(static_cast<unsigned>(iter-current.length()-data),1u,&e.first);
                        e.second.lastHit=queryId;
                     }
                     auto lower=lower_bound(e.second.patterns.begin(),e.second.patterns.end(),rolling&(~((~0ull)>>8)),[](const Pattern& a,uint64_t b) { return a.hash<b; });
                     auto upper=upper_bound(lower,e.second.patterns.end(),rolling,[](uint64_t a,const Pattern& b) { return a<b.hash; });
                     unsigned len=1;
                     while (lower<upper) {
                        if (lower->hash==getFirst(rolling,lower->len)) {
                           checkMatch(hits,*lower,data,iter,queryId);
                           ++lower;
                        } else {
                           ++len;
                           unsigned diff=__builtin_clzll(lower->hash^rolling)>>3;
                           if (diff>len) len=diff;
                           lower=lower_bound(lower+1,upper,rolling&(~((~0ull)>>(8*len))),[](const Pattern& a,uint64_t b) { return a.hash<b; });
                        }
                     }
                  }
                  rolling=(rolling>>8)|(hashString(current)&(~((~0ull)>>8)));
                  current.clear();
                  if (iter==limit) break;
               } else current+=*iter;
            }
            if (hits.empty()) {
               cout << "-1" << endl;
            } else {
               sort(hits.begin(),hits.end());
               bool first=true;
               for (auto& h:hits) {
                  if (first) first=false; else cout << "|";
                  cout << *get<2>(h);
               }
               cout << endl;
            }
            break;
         }
         default: cerr << "malformed input" << endl; return 1;
      }
   }

   auto stop = chrono::steady_clock::now();
   auto duration = chrono::duration_cast<chrono::milliseconds>(stop - start).count();
   cerr << "execution time " << (duration/1000.0) << " words: " << words << " candidates: " << candidates << " full checks: " << checks << " hits " << hitCount << endl;
}
