#ifndef NEUMANNMATCHER_HPP
#define NEUMANNMATCHER_HPP

#include "Matcher.hpp"
#include <experimental/string_view>
#include <vector>
#include "campers/hashtable.hpp"
#include "google/farmhash.hpp"
#include <stdint.h>
#include <unordered_map>
#include "Hash.hpp"

using namespace std;
using namespace campers;
using namespace std::experimental;

class NeumannMatcher : public Matcher {

  struct stringhash {
    public:
    uint64_t operator()(const string_view& s) const
    {
      return crc32_hash_rowdy(s.data(),s.size());
    }

    uint64_t operator()(const char* s, uint64_t len) const
    {
      return crc32_hash_rowdy(s, len);
    }
  };
  stringhash hash;


  /// A pattern
  struct Pattern {
    /// The hash value
    uint64_t hash;
    /// The full string
    string_view pattern;
    /// The pattern length in words
    unsigned len;
    /// The last hit
    unsigned lastHit=0;
  };

  struct WordEntry {
    /// Additional patterns
    vector<Pattern> patterns;
    /// Last hit
    unsigned lastHit=0;
    /// Already a match?
    bool match=false;
  };

  const uint32_t INIT_SIZE_QUERY_VECTORS=1ul<<7;

  unsigned checks = 0, hitCount = 0;
  unsigned wordCount=0,candidates=0;
  unsigned queryId=0;
  HashMap<string_view,WordEntry, stringhash> hashTable;

  void checkMatch(vector<tuple<unsigned,unsigned,const string_view*>>& hits, NeumannMatcher::Pattern& pattern,const char* begin,const char* limit,unsigned queryId);
  void addPattern(string_view& line);
  void deletePattern(string_view& line);


 public:
  void resetStats() {}
  void printStats() {}
  void grow() { hashTable.grow(); }
  NeumannMatcher();
  void query(const string_view document) noexcept;
  void add(const string_view ngram) noexcept;
  void remove(const string_view ngram) noexcept;
  ~NeumannMatcher();
};

#endif
