import java.util.Arrays;
import java.util.Collection;

public class MyBinaryTree<T extends Comparable<T>> {

  private TreeNode<T> root;

  public MyBinaryTree() {
    root = null;
  }

  public void printInOrder() {
    if (root != null) {
      root.printInOrder();
    }
  }

  public void insert(T element) {
    if (root == null) {
      root = new TreeNode<>(element);
    } else {
      root.insert(element);
    }
  }

  public void insert(Collection<T> list) {
    for (T t : list) {
      insert(t);
    }
  }

  public T search(T element) {
    if (root == null) {
      return null;
    } else {
      return root.search(element);
    }
  }

  public void delete(T element) {
    // Empty tree
    if (root == null) {
      return;
    }

    // If root itself contains element
    if (root.key.equals(element)) {
      // Case 1: no children
      if ((root.leftChild == null) && (root.rightChild == null)) {
        root = null;
      }
      // Case 2+3: 1 child
      else if ((root.leftChild != null) && (root.rightChild == null)) {
        root = root.leftChild;
        root.parent = null;
      } else if ((root.leftChild == null) && (root.rightChild != null)) {
        root = root.rightChild;
        root.parent = null;
      }
      // Case 4: two children
      else {
        root.leftChild.insert(root.rightChild);
        root = root.leftChild;
        root.parent = null;
      }
      return;
    }

    // At this point ensured that root does not contain key, delegate to root node
    root.delete(element);
  }

  private static class TreeNode<T extends Comparable<T>> {
    private final T key;
    private TreeNode<T> leftChild;
    private TreeNode<T> rightChild;
    private TreeNode<T> parent;

    TreeNode(T key) {
      this(key, null);
    }

    TreeNode(T key, TreeNode<T> parent) {
      this.key = key;
      this.parent = parent;
      this.leftChild = null;
      this.rightChild = null;
    }

    public void printInOrder() {
      if (leftChild != null) {
        leftChild.printInOrder();
      }
      System.out.println(this.key);
      if (rightChild != null) {
        rightChild.printInOrder();
      }
    }

    public void insert(T element) {
      insert(new TreeNode<T>(element, null));
    }

    public void insert(TreeNode<T> node) {
      if (key.compareTo(node.key) > 0) {
        if (leftChild != null) {
          leftChild.insert(node);
        } else {
          node.parent = this;
          leftChild = node;
        }
      }
      if (key.compareTo(node.key) < 0) {
        if (rightChild != null) {
          rightChild.insert(node);
        } else {
          node.parent = this;
          rightChild = node;
        }
      }
    }

    public T search(T element) {
      if (key.equals(element)) {
        return element;
      }

      if (key.compareTo(element) > 0 && leftChild != null) {
        return leftChild.search(element);
      } else if (key.compareTo(element) < 0 && rightChild != null) {
        return rightChild.search(element);
      } else {
        return null;
      }
    }

    private void replaceChild(TreeNode<T> child, TreeNode<T> replacement) {
      if (leftChild == child) {
        leftChild = replacement;
      } else if (rightChild == child) {
        rightChild = replacement;
      }
    }

    public void delete(T element) {
      // Found node
      if (key.equals(element)) {
        // Fall 1: no children
        if ((leftChild == null) && (rightChild == null)) {
          parent.replaceChild(this, null);
        }
        // Fall 2+3: 1 child
        else if ((leftChild != null) && (rightChild == null)) {
          parent.replaceChild(this, leftChild);
        } else if ((leftChild == null) && (rightChild != null)) {
          parent.replaceChild(this, rightChild);
        }
        // Fall 4: two children
        else {
          parent.replaceChild(this, leftChild);// cut out, connect left child to parent; insert right child later
          leftChild.insert(rightChild);// eventually results in strong unbalance
        }
        return;
      }

      // Traverse downwards the tree
      if (key.compareTo(element) > 0 && leftChild != null) {
        leftChild.delete(element);
      } else if (key.compareTo(element) < 0 && rightChild != null) {
        rightChild.delete(element);
      }
    }
  }

  public static void main(String[] args) {
    MyBinaryTree<Integer> test_tree = new MyBinaryTree<>();


    Integer[] intArray = {15, 7, 33, 42, 1, 12, 12, 33, 14, 16};
    test_tree.insert(Arrays.asList(intArray));
    test_tree.printInOrder();
    test_tree.delete(15);
    test_tree.delete(33);
    test_tree.delete(1);
    System.out.println("--");
    test_tree.printInOrder();
  }
}