import java.util.List;
import java.util.HashMap;

class MovieTitleSearchLoesung {
  HashMap<String, Movie> movies;

  // Konstruktor
  public MovieTitleSearchLoesung() {
    movies = new HashMap<String, Movie>();
  }

  public void insertMovieForTitle(String title, Movie movie) {
    movies.put(title, movie);
  }

  public Movie getMovieForTitle(String title) {
    return movies.get(title);
  }

  // Dieser Client verwendet Ihre Implementierung
  public static void main(String[] args) {
    MovieTitleSearchLoesung movieSearch = new MovieTitleSearchLoesung();

    // Filme einfuegen
    List<Movie> movies = Movie.readMoviesFromFile("movies.txt");
    for (Movie m : movies) {
      movieSearch.insertMovieForTitle(m.title, m);
    }

    // Punktzugriff
    Movie movie = movieSearch.getMovieForTitle("Pulp Fiction");

    // Ausgabe
    System.out.println(movie);
  }
}