import java.util.List;
import java.util.ArrayList;

class MovieRankSearchLoesung {
  ArrayList<Movie> movies;

  // Konstruktor
  public MovieRankSearchLoesung() {
    movies = new ArrayList<Movie>(250);
  }

  public void insertMovieWithRank(int rank, Movie movie) {
    // Muss von Index 0 an befuellt werden
    movies.add(rank-1, movie);
  }

  public Movie getMovieForRank(int rank) {
    return movies.get(rank-1);
  }

  // Dieser Client verwendet Ihre Implementierung
  public static void main(String[] args) {
    MovieRankSearchLoesung movieSearch = new MovieRankSearchLoesung();

    // Filme einfuegen
    List<Movie> movies = Movie.readMoviesFromFile("movies.txt");
    for (Movie m : movies) {
      movieSearch.insertMovieWithRank(m.rank, m);
    }

    // Punktzugriff
    Movie movie = movieSearch.getMovieForRank(42);

    // Ausgabe
    System.out.println(movie);
  }
}