#include "util/input.hpp"
#include "util/log.hpp"
#include <unistd.h>
#include <cstring>

static const char LINE_END = '\n';


void BufferedInput::reset()
{
   if (offset != available) {
       return;
      auto ptr = buffer.data();
      auto rest = available-offset+1;
      memmove(ptr, ptr+offset, rest);
      available = rest;
      offset=0;
      return;
   }
   offset = 0;
   available = 0;
}

void BufferedInput::fill()
{
   auto freeSpace = buffer.size() - available;
   if (freeSpace == 0) {
      FATAL_ERROR("No buffer space left for input - " << buffer.size());
   }
   auto result = read(STDIN_FILENO, buffer.data() + available, freeSpace);
   if (result == 0) {
      eof = true;
   }
   else {
      available += result;
   }
}

size_t BufferedInput::fillChunk(uint64_t size)
{
   auto freeSpace = buffer.size() - available;
   if (freeSpace == 0) {
      FATAL_ERROR("No buffer space left for input - " << buffer.size());
   }
   auto result = read(STDIN_FILENO, buffer.data() + available, std::min(size,freeSpace));
   return result;
}
