#pragma once

#include "util/log.hpp"
#include <string>
#include <vector>


template <typename Processor, typename Validator> class ValidatingNgramer {
   Processor processor;
   Validator validator;

   public:
   ValidatingNgramer() = default;

   std::vector<std::string> query(const std::string& document)
   {
      auto result = processor.query(document);
      auto validate = validator.query(document);
      if (result != validate) {
         std::cerr << stringify(result) << std::endl;
         std::cerr << stringify(validate) << std::endl;
         FATAL_ERROR("Mismatch: " << document);
      }
      return result;
   }

   void add(std::string&& ngram)
   {
      std::string copy = ngram;
      processor.add(std::move(copy));
      validator.add(std::move(ngram));
   }

   void remove(const std::string& ngram)
   {
      std::string copy = ngram;
      processor.remove(std::move(copy));
      validator.remove(std::move(ngram));
   }
};