#pragma once

#include "util/timer.hpp"

class SectionTimer {
   util::timer::Cycles lastTime;

   util::timer::Cycles parseTime;
   util::timer::Cycles queryTime;
   util::timer::Cycles additionTime;
   util::timer::Cycles removeTime;
   util::timer::Cycles writeTime;

   public:
   SectionTimer()
      : lastTime(util::timer::cycles()), parseTime({0}), queryTime({0}), additionTime({0}), removeTime({0}), writeTime({0})
   {
   }

   void traceParse();

   void traceQuery();

   void traceAddition();

   void traceRemove();

   void traceWrite();

   void print() const;

   void reset();
};